<?php
global $theme_sidebars;
$places = array();
foreach ($theme_sidebars as $sidebar){
    if ($sidebar['group'] !== 'footer')
        continue;
    $widgets = theme_get_dynamic_sidebar_data($sidebar['id']);
    if (!is_array($widgets) || count($widgets) < 1)
        continue;
    $places[$sidebar['id']] = $widgets;
}
$place_count = count($places);
$needLayout = ($place_count > 1);
if (theme_get_option('theme_override_default_footer_content')) {
    if ($place_count > 0) {
        $centred_begin = '<div class="art-center-wrapper"><div class="art-center-inner">';
        $centred_end = '</div></div><div class="clearfix"> </div>';
        if ($needLayout) { ?>
<div class="art-content-layout">
    <div class="art-content-layout-row">
        <?php 
        }
        foreach ($places as $widgets) { 
            if ($needLayout) { ?>
            <div class="art-layout-cell art-layout-cell-size<?php echo $place_count; ?>">
            <?php 
            }
            $centred = false;
            foreach ($widgets as $widget) {
                 $is_simple = ('simple' == $widget['style']);
                 if ($is_simple) {
                     $widget['class'] = implode(' ', array_merge(explode(' ', theme_get_array_value($widget, 'class', '')), array('art-footer-text')));
                 }
                 if (false === $centred && $is_simple) {
                     $centred = true;
                     echo $centred_begin;
                 }
                 if (true === $centred && !$is_simple) {
                     $centred = false;
                     echo $centred_end;
                 }
                 theme_print_widget($widget);
            } 
            if (true === $centred) {
                echo $centred_end;
            }
            if ($needLayout) {
           ?>
            </div>
        <?php 
            }
        } 
        if ($needLayout) { ?>
    </div>
</div>
        <?php 
        }
    }
?>
<div class="art-footer-text">
<?php
global $theme_default_options;
echo do_shortcode(theme_get_option('theme_override_default_footer_content') ? theme_get_option('theme_footer_content') : theme_get_array_value($theme_default_options, 'theme_footer_content'));
} else { 
?>
<div class="art-footer-text">
<?php theme_ob_start() ?>
  
<div class="art-content-layout">
    <div class="art-content-layout-row">
    <div class="art-layout-cell layout-item-0" style="width: 20%"><?php if (false === theme_print_sidebar('footer-1-widget-area')) { ?>
        <p style="font: bold 18px 'Arial';">INFO</p>
        <br />
        <ul>
        <li><a href="#">Welcome</a></li>
        <li><a href="#">People</a></li>
        <li><a href="#">Management</a></li>
        </ul>
    <?php } ?></div><div class="art-layout-cell layout-item-0" style="width: 20%"><?php if (false === theme_print_sidebar('footer-2-widget-area')) { ?>
        <p style="font: bold 18px 'Arial';">LOCATION</p>
        <br />
        <ul>
        <li><a href="#">Map</a></li>
        <li><a href="<?php theme_ob_start() ?>[post_link name='/contact-us']<?php echo do_shortcode(theme_ob_get_clean()) ?>">Address</a></li>
        <li><a href="<?php theme_ob_start() ?>[post_link name='/contact-us']<?php echo do_shortcode(theme_ob_get_clean()) ?>">Contact Us</a></li>
        </ul>
    <?php } ?></div><div class="art-layout-cell layout-item-0" style="width: 20%"><?php if (false === theme_print_sidebar('footer-3-widget-area')) { ?>
        <p style="font: bold 18px 'Arial';">ABOUT</p>
        <br />
        <ul>
        <li><a href="<?php theme_ob_start() ?>[post_link name='/about-us']<?php echo do_shortcode(theme_ob_get_clean()) ?>">Company</a></li>
        <li><a href="#">Terms</a></li>
        </ul>
    <?php } ?></div><div class="art-layout-cell layout-item-0" style="width: 40%"><?php if (false === theme_print_sidebar('footer-4-widget-area')) { ?>
        <p style="text-align:right;"><a href="http://loadmacusa.com/feed/" target="_blank"><img width="32" height="32" alt="" src="<?php echo get_template_directory_uri() ?>/images/rss_32-2.png" /></a><a href="https://www.facebook.com/Loadmac-USA-2127347154177029/" target="_blank"><img width="32" height="32" alt="" src="<?php echo get_template_directory_uri() ?>/images/facebook_32-2.png" class="" /></a><a href="https://twitter.com/loadmac" target="_blank"><img width="32" height="32" alt="" src="<?php echo get_template_directory_uri() ?>/images/twitter_32.png" class="" /></a>&nbsp;<a href="https://www.linkedin.com/" target="_blank"><img width="32" height="32" alt="" src="<?php echo get_template_directory_uri() ?>/images/linkedin_32.png" class="" /></a></p>
        <p style="text-align:right;">Copyright © 2018. All Rights Reserved.</p><p style="text-align:right;">Website created by <a href="http://jasonpence.com/" target="_blank">Jason Pence</a></p>
    <?php } ?></div>
    </div>
</div>

  
<?php echo do_shortcode(theme_ob_get_clean()) ?>
<?php } ?>

</div>
